import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, concatenate_objects, bind_dataframe, reset_index, rename_columns, join_dataframes, assert_series, extract_unique_values, fetch_df_size, create_multiindex_from_product, convert_multiindex_to_dataframe, remove_labels, fill_missing_values


atp_tennis = read_csv_file('atp_tennis.csv')

def calculate_head_to_head_win_rate(data):
    unique_players = extract_unique_values(concatenate_objects(data['Player_1'], data['Player_2']))

    total_matches = reset_index(fetch_df_size(bind_dataframe(data, ['Player_1', 'Player_2'])), drop=False)
    total_matches = rename_columns(total_matches, columns={0: 'count_total'})

    player_wins = fetch_df_size(bind_dataframe(data[assert_series(data['Winner'], data['Player_1'], 'equality')], ['Player_1', 'Player_2']))
    player_wins = reset_index(player_wins, drop=False)
    player_wins = rename_columns(player_wins, {0: 'count_wins'})

    multiindex = create_multiindex_from_product([unique_players, unique_players], names=['Player', 'Opponent'])
    all_pairs = convert_multiindex_to_dataframe(multiindex, index=False)
    all_pairs = all_pairs[assert_series(all_pairs['Player'], all_pairs['Opponent'], 'inequality')]

    h2h_win_rates = remove_labels(join_dataframes(all_pairs, total_matches, left_on=['Player', 'Opponent'], right_on=['Player_1', 'Player_2'], how='left'), columns=['Player_1', 'Player_2'])
    h2h_win_rates = remove_labels(join_dataframes(h2h_win_rates, player_wins, left_on=['Player', 'Opponent'], right_on=['Player_1', 'Player_2'], how='left'), columns=['Player_1', 'Player_2'])

    fill_missing_values(h2h_win_rates['count_wins'], value=0, inplace=True)
    fill_missing_values(h2h_win_rates['count_total'], value=1, inplace=True)

    h2h_win_rates['Head-to-Head Win Rate'] = h2h_win_rates['count_wins'] / h2h_win_rates['count_total']
    h2h_win_rates = remove_labels(h2h_win_rates, columns=['count_total', 'count_wins'])

    return h2h_win_rates
